package com.group_finity.mascot;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.ConfigurationException;

/**
 * vÕGg|Cg.
 */
public class Main {

	private static final Logger log = Logger.getLogger(Main.class.getName());

	static final String BEHAVIOR_GATHER = "}EX̎ɏW܂";

	static {
		try {
			LogManager.getLogManager().readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
		} catch (final SecurityException e) {
			e.printStackTrace();
		} catch (final IOException e) {
			e.printStackTrace();
		}
	}

	private static Main instance = new Main();

	public static Main getInstance() {
		return instance;
	}

	private final Manager manager = new Manager();

	private final Configuration configuration = new Configuration();

	public static void main(final String[] args) {

		getInstance().run();
	}

	public void run() {

		// ݒǂݍ
		loadConfiguration();

		// gCACR쐬
		createTrayIcon();

		// ߂C쐬
		createMascot();
		
		getManager().start();
	}

	private void loadConfiguration() {

		try {
			log.log(Level.INFO, "ݒt@Cǂݍ({0})", "/.xml");

			final Document actions = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(
					Main.class.getResourceAsStream("/.xml"));

			log.log(Level.INFO, "ݒt@Cǂݍ({0})", "/s.xml");

			this.getConfiguration().load(new Entry(actions.getDocumentElement()));

			final Document behaviors = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(
					Main.class.getResourceAsStream("/s.xml"));

			this.getConfiguration().load(new Entry(behaviors.getDocumentElement()));

			this.getConfiguration().validate();

		} catch (final IOException e) {
			log.log(Level.SEVERE, "ݒt@C̓ǂݍ݂Ɏs", e);
			exit();
		} catch (final SAXException e) {
			log.log(Level.SEVERE, "ݒt@C̓ǂݍ݂Ɏs", e);
			exit();
		} catch (final ParserConfigurationException e) {
			log.log(Level.SEVERE, "ݒt@C̓ǂݍ݂Ɏs", e);
			exit();
		} catch (final ConfigurationException e) {
			log.log(Level.SEVERE, "ݒt@C̋LqɌ肪܂", e);
			exit();
		}
	}

	/**
	 * gCACR쐬.
	 * @throws AWTException
	 * @throws IOException
	 */
	private void createTrayIcon() {

		log.log(Level.INFO, "gCACR쐬");

		// u₷vj[ACe
		final MenuItem increaseMenu = new MenuItem("₷");
		increaseMenu.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent event) {
				createMascot();
			}
		});

		// u܂Ivj[ACe
		final MenuItem gatherMenu = new MenuItem("܂I");
		gatherMenu.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent event) {
				Main.this.getManager().setBehaviorAll(Main.this.getConfiguration(), BEHAVIOR_GATHER);
			}
		});

		// uCcvj[ACe
		final MenuItem oneMenu = new MenuItem("Cc");
		oneMenu.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent event) {
				Main.this.getManager().remainOne();
			}
		});

		// uIEɖ߂vj[ACe
		final MenuItem restoreMenu = new MenuItem("IEɖ߂");
		restoreMenu.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent event) {
				NativeFactory.getInstance().getEnvironment().restoreIE();
			}
		});

		// u΂΂vj[ACe
		final MenuItem closeMenu = new MenuItem("΂΂");
		closeMenu.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				exit();
			}
		});

		// |bvAbvj[쐬
		final PopupMenu trayPopup = new PopupMenu();
		trayPopup.add(increaseMenu);
		trayPopup.add(gatherMenu);
		trayPopup.add(oneMenu);
		trayPopup.add(restoreMenu);
		trayPopup.add(new MenuItem("-"));
		trayPopup.add(closeMenu);

		try {
			// gCACR쐬
			final TrayIcon icon = new TrayIcon(ImageIO.read(Main.class.getResource("/icon.png")), "߂", trayPopup);
			icon.addMouseListener(new MouseAdapter() {
				@Override
				public void mouseClicked(final MouseEvent e) {
					// ACR_uNbNꂽƂuv
					if (SwingUtilities.isLeftMouseButton(e)) {
						createMascot();
					}
				}
			});
			
			// gCACR\
			SystemTray.getSystemTray().add(icon);

		} catch (final IOException e) {
			log.log(Level.SEVERE, "gCACR̍쐬Ɏs", e);
			exit();

		} catch (final AWTException e) {
			log.log(Level.SEVERE, "gCACR̍쐬Ɏs", e);
			Mascot.setShowSystemTrayMenu(true);
			getManager().setExitOnLastRemoved(true);
		}

	}

	/**
	 * ߂C쐬.
	 */
	public void createMascot() {

		log.log(Level.INFO, "}XRbg쐬");

		// }XRbg1쐬
		final Mascot mascot = new Mascot();

		// ͈͊OJn
		mascot.setAnchor(new Point(-1000, -1000));
		// _Ȍ
		mascot.setLookRight(Math.random() < 0.5);

		try {
			mascot.setBehavior(getConfiguration().buildBehavior(null, mascot));

			this.getManager().add(mascot);

		} catch (final BehaviorInstantiationException e) {
			log.log(Level.SEVERE, "ŏ̍s̏Ɏs܂", e);
			mascot.dispose();
		} catch (final CantBeAliveException e) {
			log.log(Level.SEVERE, "邱ƂoȂ", e);
			mascot.dispose();
		}

	}

	public Configuration getConfiguration() {
		return this.configuration;
	}

	private Manager getManager() {
		return this.manager;
	}

	public void exit() {

		this.getManager().disposeAll();
		this.getManager().stop();

		System.exit(0);
	}

}
