/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import com.sun.jna.examples.WindowUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class X11AlphaMaskTest {
    private static int alpha = 128;
    private static AlphaComposite composite = AlphaComposite.Src;

    public static void main(String[] args) {
        GraphicsConfiguration gc = WindowUtils.getAlphaCompatibleGraphicsConfiguration();
        JFrame frame = new JFrame("X11 alpha test", gc);
        final JComponent content = new JComponent(){

            public Dimension getPreferredSize() {
                return new Dimension(100, 100);
            }

            private Color mix(Color c, int base) {
                float f = (float)alpha / 255.0f;
                return new Color((int)((float)c.getRed() * f + (float)base * (1.0f - f)), (int)((float)c.getGreen() * f + (float)base * (1.0f - f)), (int)((float)c.getBlue() * f + (float)base * (1.0f - f)));
            }

            protected void paintComponent(Graphics graphics) {
                BufferedImage buf = ((Graphics2D)graphics).getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
                Graphics2D g = buf.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setComposite(AlphaComposite.SrcOver);
                int barw = this.getWidth() / 10;
                int barh = this.getHeight();
                g.setColor(Color.red);
                g.fillRect(0, 0, barw, barh);
                g.setColor(new Color(255, 0, 0, alpha));
                g.fillRect(barw, 0, barw, barh / 2);
                g.setColor(this.mix(Color.red, 255));
                g.fillRect(barw, barh / 2, barw, barh / 4);
                g.setColor(this.mix(Color.red, 0));
                g.fillRect(barw, barh * 3 / 4, barw, barh / 4);
                g.setColor(Color.green);
                g.fillRect(2 * barw, 0, barw, barh);
                g.setColor(new Color(0, 255, 0, alpha));
                g.fillRect(3 * barw, 0, barw, barh / 2);
                g.setColor(this.mix(Color.green, 255));
                g.fillRect(3 * barw, barh / 2, barw, barh / 4);
                g.setColor(this.mix(Color.green, 0));
                g.fillRect(3 * barw, barh * 3 / 4, barw, barh / 4);
                g.setColor(Color.blue);
                g.fillRect(4 * barw, 0, barw, barh);
                g.setColor(new Color(0, 0, 255, alpha));
                g.fillRect(5 * barw, 0, barw, barh / 2);
                g.setColor(this.mix(Color.blue, 255));
                g.fillRect(5 * barw, barh / 2, barw, barh / 4);
                g.setColor(this.mix(Color.blue, 0));
                g.fillRect(5 * barw, barh * 3 / 4, barw, barh / 4);
                g.setColor(Color.white);
                g.fillRect(6 * barw, 0, barw, barh);
                g.setColor(new Color(255, 255, 255, alpha));
                g.fillRect(7 * barw, 0, barw, barh / 2);
                g.setColor(this.mix(Color.white, 255));
                g.fillRect(7 * barw, barh / 2, barw, barh / 4);
                g.setColor(this.mix(Color.white, 0));
                g.fillRect(7 * barw, barh * 3 / 4, barw, barh / 4);
                g.setColor(Color.black);
                g.fillRect(8 * barw, 0, barw, barh);
                g.setColor(new Color(0, 0, 0, alpha));
                g.fillRect(9 * barw, 0, barw, barh / 2);
                g.setColor(this.mix(Color.black, 255));
                g.fillRect(9 * barw, barh / 2, barw, barh / 4);
                g.setColor(this.mix(Color.black, 0));
                g.fillRect(9 * barw, barh * 3 / 4, barw, barh / 4);
                g.setColor(new Color(0, 0, 0, 128));
                g.fillRect(0, 0, this.getWidth(), barh / 10);
                g = (Graphics2D)graphics.create();
                g.setComposite(composite);
                g.drawImage(buf, 0, 0, this.getWidth(), this.getHeight(), null);
                g.dispose();
            }
        };
        final JSlider slider = new JSlider(0, 255, 128);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!slider.getModel().getValueIsAdjusting()) {
                    alpha = slider.getValue();
                    content.repaint();
                }
            }
        });
        AlphaComposite[] options = new AlphaComposite[]{AlphaComposite.Clear, AlphaComposite.Src, AlphaComposite.SrcOver, AlphaComposite.SrcAtop, AlphaComposite.SrcIn, AlphaComposite.SrcOut, AlphaComposite.Dst, AlphaComposite.DstOver, AlphaComposite.DstAtop, AlphaComposite.DstIn, AlphaComposite.DstOut, AlphaComposite.Xor};
        final JComboBox<AlphaComposite> combo = new JComboBox<AlphaComposite>(options);
        combo.setOpaque(true);
        combo.setSelectedItem(composite);
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                composite = (AlphaComposite)combo.getSelectedItem();
                content.repaint();
            }
        });
        frame.getContentPane().add(content);
        frame.getContentPane().add((Component)slider, "South");
        frame.getContentPane().add(combo, "North");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        if (System.getProperty("os.name").startsWith("Windows")) {
            WindowUtils.setWindowTransparent(frame, true);
        }
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }
}

