/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.win;

import com.group_finity.mascot.image.NativeImage;
import com.group_finity.mascot.win.jna.BITMAP;
import com.group_finity.mascot.win.jna.BITMAPINFOHEADER;
import com.group_finity.mascot.win.jna.Gdi32;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

class WindowsNativeImage
implements NativeImage {
    private final BufferedImage managedImage;
    private final Pointer nativeHandle;
    private final int[] rgb;

    private static Pointer createNative(int width, int height) {
        BITMAPINFOHEADER bmi = new BITMAPINFOHEADER();
        bmi.biSize = 40;
        bmi.biWidth = width;
        bmi.biHeight = height;
        bmi.biPlanes = 1;
        bmi.biBitCount = (short)32;
        Pointer hBitmap = Gdi32.INSTANCE.CreateDIBSection(Pointer.NULL, bmi, 0, Pointer.NULL, Pointer.NULL, 0);
        return hBitmap;
    }

    private static void flushNative(Pointer nativeHandle, int[] rgb) {
        BITMAP bmp = new BITMAP();
        Gdi32.INSTANCE.GetObjectW(nativeHandle, 20 + Native.POINTER_SIZE, bmp);
        int width = bmp.bmWidth;
        int height = bmp.bmHeight;
        int destPitch = (bmp.bmWidth * bmp.bmBitsPixel + 31) / 32 * 4;
        int destIndex = destPitch * (height - 1);
        int srcIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bmp.bmBits.setInt(destIndex + x * 4, (rgb[srcIndex] & 0xFF000000) == 0 ? 0 : rgb[srcIndex]);
                ++srcIndex;
            }
            destIndex -= destPitch;
        }
    }

    private static void freeNative(Pointer nativeHandle) {
        Gdi32.INSTANCE.DeleteObject(nativeHandle);
    }

    public WindowsNativeImage(BufferedImage image) {
        this.managedImage = image;
        this.nativeHandle = WindowsNativeImage.createNative(this.getManagedImage().getWidth(), this.getManagedImage().getHeight());
        this.rgb = new int[this.getManagedImage().getWidth() * this.getManagedImage().getHeight()];
        this.update();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        WindowsNativeImage.freeNative(this.getNativeHandle());
    }

    public void update() {
        this.getManagedImage().getRGB(0, 0, this.getManagedImage().getWidth(), this.getManagedImage().getHeight(), this.getRgb(), 0, this.getManagedImage().getWidth());
        WindowsNativeImage.flushNative(this.getNativeHandle(), this.getRgb());
    }

    public void flush() {
        this.getManagedImage().flush();
    }

    public Pointer getHandle() {
        return this.getNativeHandle();
    }

    public Graphics getGraphics() {
        return this.getManagedImage().createGraphics();
    }

    public int getHeight() {
        return this.getManagedImage().getHeight();
    }

    public int getWidth() {
        return this.getManagedImage().getWidth();
    }

    public int getHeight(ImageObserver observer) {
        return this.getManagedImage().getHeight(observer);
    }

    public Object getProperty(String name, ImageObserver observer) {
        return this.getManagedImage().getProperty(name, observer);
    }

    public ImageProducer getSource() {
        return this.getManagedImage().getSource();
    }

    public int getWidth(ImageObserver observer) {
        return this.getManagedImage().getWidth(observer);
    }

    private BufferedImage getManagedImage() {
        return this.managedImage;
    }

    private Pointer getNativeHandle() {
        return this.nativeHandle;
    }

    private int[] getRgb() {
        return this.rgb;
    }
}

